class WeaponGSH18 extends MarkistanCityGuns;

//+++++++++++++
//Icons
//+++++++++++++
#exec TEXTURE IMPORT NAME=BeltIconGSH18 FILE=Textures\BeltIconGSH18FIN.PCX GROUP=Icons //Belt
#exec TEXTURE IMPORT NAME=InventoryIconGSH18 FILE=Textures\InventoryIconGSH18FIN.PCX GROUP=Icons //Inventory

//-------------
//Sounds
//-------------
#exec AUDIO IMPORT FILE="C:\DeusEx\MarkistanCity\Sounds\HandgunFire.wav" NAME="GSH18Fire" GROUP="Weapons"

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		bHasLaser = False;
	}
}

defaultproperties
{
     bInstantHit=True
     bKnockBack=True
     KnockBackAmount=190
     PenetrationPower=40
     ShotTime=0.4500000
     reloadTime=0.700000
     HitDamage=25
     maxRange=10000
     AccurateRange=5000
     bHasLaser=True
     mpReloadTime=0.700000
     mpHitDamage=25
     mpReloadCount=12
     bCanHaveModAccurateRange=False
     AmmoName=Class'MarkistanCity.MSCAmmo9mm'
     ReloadCount=12
     PickupAmmoCount=36
     SelectSound=Sound'DeusExSounds.Weapons.PistolSelect'
     AltFireSound=Sound'Markistan.Weapons.PistolCock'
     CockingSound=Sound'Markistan.Weapons.PistolReload'
     FireSound=Sound'GSH18Fire'
     InventoryGroup=202
     ItemName="GSH-18"
     invSlotsX=2
     Description="A Russian GSH-18 Handgun."
     beltDescription="GSH 18"
     Icon=Texture'BeltIconGSH18'
     largeIcon=Texture'InventoryIconGSH18'
     largeIconWidth=64
     largeIconHeight=48
     LowAmmoWaterMark=12
     GoverningSkill=Class'DeusEx.SkillWeaponPistol'
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_Visual
     bCanHaveScope=True
     ScopeFOV=25
     bCanHaveLaser=True
     recoilStrength=0.300000
     mpAccurateRange=1200
     mpMaxRange=1200
     bCanHaveModReloadCount=True
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=True
     FireOffset=(X=-22.000000,Y=10.000000,Z=14.000000)
     PlayerViewOffset=(X=22.000000,Y=-10.000000,Z=-14.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Glock'
     PickupViewMesh=LodMesh'DeusExItems.GlockPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.Glock3rd'
     Mesh=LodMesh'DeusExItems.GlockPickup'
     CollisionRadius=7.000000
     CollisionHeight=1.000000
     bHasLaser=True
     mpBaseAccuracy=0.100000
     bCanHaveModBaseAccuracy=False
     bHandToHand=False
}
